/*
 PTA5/IRQ/TCLK/RESET  (1)       (20)  PTA0/PIA0/TPM1CH0/ADP0/ACMP+
  PTA4/ACMPO/BKGD/MS  (2)       (19)  PTA1/PIA1/TPM2CH0/ADP1/ACMP-
                 VDD  (3)       (18)  PTA2/PIA2/SDA/ADP2
                 VSS  (4)       (17)  PTA3/PIA3/SCL/ADP3
      PTB7/SCL/EXTAL  (5)       (16)  PTB0/PIB0/RxD/ADP4
       PTB6/SDA/XTAL  (6)       (15)  PTB1/PIB1/TxD/ADP5
     PTB5/TPM1CH1/SS  (7)       (14)  PTB2/PIB2/SPSCK/ADP6
   PTB4/TPM2CH1/MISO  (8)       (13)  PTB3/PIB3/MOSI/ADP7
          PTC3/ADP11  (9)       (12)  PTC0/TPM1CH0/ADP8
          PTC2/ADP10  (10)      (11)  PTC1/TPM1CH1/ADP9
*/


#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */



#define LCD_RS	PTCD_PTCD0 
#define LCD_E 	PTCD_PTCD1
//#define LCD_RW

#define LCD_D7	PTBD_PTBD7
#define LCD_D6	PTBD_PTBD6
#define LCD_D5	PTBD_PTBD5
#define LCD_D4	PTBD_PTBD4
#define LCD_D3	PTBD_PTBD3
#define LCD_D2	PTBD_PTBD2
#define LCD_D1	PTBD_PTBD1
#define LCD_D0	PTBD_PTBD0
//#define LCD_8bits 1
#define LCD_4bits 1
#define DATO 	1
#define COMANDO 0
#define LINEA1  0x80
#define LINEA2  0xC0
#define LINEA3  0x94
#define LINEA4  0xD4

unsigned short LCD_tout=0;  // Contador para decrementar cada 1mS



void MCU_init (void);		//Esta funcin Inicializa al CPU
void CLCK_init(void);		//Esta funcin Inicializa el clock del microcontrolador
void PORT_init(void);		//Esta funcin Inicializa los puertos del microcontrolador
void TIM1_init(void);		//Esta funcin Inicializa el timer 1

void LCDwrite(unsigned char dato, unsigned char tipo);
void LCDinit (void);
void LCDtic(void);
void LCDclear(void);
void LCDprint(unsigned char *msg, unsigned char linea);
void LCDuserchar(unsigned char NumeroUserChar, unsigned char NumeroCharTabla);

void main(void) {
	MCU_init();
	CLCK_init();
	PORT_init();
	TIM1_init();
	EnableInterrupts;
  /* include your code here */
	LCDinit();
  /*Genero 4 caracteres especiales*/
	LCDuserchar(0,0);
	LCDuserchar(1,1);
	LCDuserchar(2,2);
	LCDuserchar(3,3);
	LCDclear();
  /*Mensaje de Bienvenida*/
	LCDprint("  COMPUTADORAS  ",1);
	LCDprint("  ELECTRONICAS  ",2);
	LCDwrite(0x80,COMANDO);
	LCDwrite(1,DATO);
	LCDwrite(0xCF,COMANDO);
	LCDwrite(1,DATO);
  /***********************/
 	
	for(;;) {
    __RESET_WATCHDOG();	/* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}


void CLCK_init(void){
	ICSTRM = *(unsigned char*far)0xFFAF;					// Initialize ICSTRM register from a non volatile memory
	ICSSC_FTRIM = 0x01 & (*(unsigned char*far)0xFFAE);		// Initialize ICSSC register from a non volatile memory
 // [7:6]CLKS=0 [5:3]RDIV=0 [2]IREFS=1 [1]IRCLKEN=0 [0]IREFSTE
	ICSC1 = 0x04;
 // [7:6]BDIV=01 [5]RANGE=0 [4]HGO=0 [3]LP=0 [2]EREFS=0 [1]ERCLKEN=0 [0]EREFSTEN=0
	ICSC2 = 0x40;
	while(!ICSSC_IREFST);
}

void MCU_init (void){
 // [7:6]COPT=00 [5]STOPE=0 [2]IICPS=0 [1]BKGDPE=1 [0]RSTPE=1
	SOPT1 = 0x03;				// WatchDog Apagado, Stop Mode Disable, SDA-PTA2 y SCL-PTA3, PTA4-BKGD, PTA5-RESET, 																						
 // [7]COPCLKS=0 [6]COPW=0 [4]ACIC=0 [1]T1CH1PS=0 [0]T1CH0PS=0
	SOPT2 = 0x00;
}

void PORT_init(void){
	PTAD = 0;		//Limpio los pines del puerto
	PTBD = 0;
	PTCD = 0;
	
	PTADD=0b00000000;
	PTBDD=0b11111111;
	PTCDD=0b00001111;
}

void TIM1_init(void){		
 // [7]TOF=0 [6]TOIE=0 [5]CPWMS=0 [4:3]CLKSB=00 [2:0]PS=011
	TPM1SC = 0x03;				//Interrupciones Deshabilitadas, TPM Apgado, Clock/8 
 // Tiempo=(TMOD*PS)/fBus --> TMOD=(Tiempo*fBus)/PS
	TPM1MOD = 1000;
 // [4:3]CLKSB=01
	TPM1SC_CLKSx = 0b01;		// TPM Clock = Bus Rate Clock 
 //	[6]TOIE=0
	TPM1SC_TOIE = 1;			// Interrupciones Habilitadas
}

// Interrupcion cada 1mS
void __interrupt 11 TPM1_ovf (void)
{
	TPM1SC_TOF = 0;				//Damos ACK a la isr del TPM1
	
	LCDtic();
}

/*
 * Esta funcin envia un dato por el Bus del LCD.
 * Si Tipo=1, el dato al LCD es COMANDO
 * Si Tipo=0, e dato al LCD es DATO
 * 
 * La funcin determina segun #define si es de 4 u 8 bits
 */
void LCDwrite(unsigned char dato, unsigned char tipo)
{
	LCD_RS = tipo;
	LCD_E = 0;					// Deshabilita el Display

	LCD_D7 = dato>>7;			// Acomoda el dato
	LCD_D6 = dato>>6;
	LCD_D5 = dato>>5;
	LCD_D4 = dato>>4;
#ifdef LCD_8bits
	LCD_D3 = dato>>3;
	LCD_D2 = dato>>2;
	LCD_D1 = dato>>1;
	LCD_D0 = dato>>0;
#endif
	LCD_E = 1;					// Habilita el display
	asm nop;
	LCD_E = 0;					// Deshabilita el Display

	
#ifdef LCD_4bits
	LCD_tout = 2; while (LCD_tout);  // Espera 2mS
	LCD_D7 = dato>>3;
	LCD_D6 = dato>>2;
	LCD_D5 = dato>>1;
	LCD_D4 = dato>>0;

	LCD_E = 1;					// Habilita el display
	asm nop;
	LCD_E = 0;					// Deshabilita el Display
#endif

	LCD_tout = 2; while (LCD_tout);  // Espera 2mS
}

/*
 * Inicializa al display segun #define
 * Puede inicializar en 4bit u 8 bits
 */
void LCDinit(void)
{    
	LCD_tout = 30; while (LCD_tout); // Espera 30mS

	LCDwrite (0x02,COMANDO);
	LCD_tout = 1; while (LCD_tout);  // Espera 1mS

	#ifdef LCD_8bits
    LCDwrite (0x38,COMANDO);         //8 bits, 2 lines, 5x8 dots
#endif
#ifdef LCD_4bits
    LCDwrite (0x28,COMANDO);         //4 bits, 2 lines, 5x8 dots
#endif
	LCD_tout = 1; while (LCD_tout);  // Espera 1mS

	LCDwrite (0x01,COMANDO);         //clear display & cursor home
	LCD_tout = 2; while (LCD_tout);  // Espera 2mS
	
	LCDwrite (0x0C,COMANDO);         //display on, cursor off & fixed
	LCD_tout = 1; while (LCD_tout);  // Espera 1mS
	
	LCDwrite (0x06,COMANDO);          //incr right, shift off
	LCD_tout = 30; while (LCD_tout);  // Espera 30mS
}

/*
 * HACER EL LLAMADO A ESTA FUNCION CADA 1mSeg
 * Decrementa la variable si su valor !=0
 */
void LCDtic(void){
	 if (LCD_tout) LCD_tout--;
}


/*
 * Limpia la Pantalla y envia el cursor a Home
 */
void LCDclear(void){
	LCDwrite (0x01,COMANDO);
	LCD_tout = 2; while (LCD_tout);  // Espera 2mS
}

/*
 * Envia un string al LCD
 */
void LCDprint(unsigned char *msg, unsigned char linea){
	if(linea==1) LCDwrite (LINEA1,COMANDO);
	if(linea==2) LCDwrite (LINEA2,COMANDO);
	while(*msg)LCDwrite(*msg++,DATO);
}

/*
 * Tabla de caracteres para escribir en la CGRAM
 */
const unsigned char TablaChars[] ={ 
		0x00, 0x00, 0x0a, 0x04, 0x11, 0x0e, 0x00, 0x00,  //:)
		0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x11, 0x00,  //:(
		0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x00, 0x00,  //:|
		0x00, 0x00, 0x0a, 0x04, 0x00, 0x0e, 0x0e, 0x00,  //:o
  
};

/*
 * Funcion para guardar caracter en la CGRAM
 */
void LCDuserchar(unsigned char NumeroUserChar, unsigned char NumeroCharTabla){
	unsigned char CGRAM=0,i=0;
    //calculo de CGRAM
    CGRAM=(unsigned char)(NumeroUserChar*8)+0x40;
    for (i=0;i<8;i++){
    	LCDwrite(CGRAM,COMANDO);                          //escribir cgram
    	LCDwrite(TablaChars[NumeroCharTabla*8+i],DATO);   //escribir dato en cgram
        CGRAM++;
      }
}